# (S)ophie's (S)tatic (S)ite (G)enerator

## Usage
`bun add git+https://git.sad.ovh/sophie/sssg`

## example
```ts
import SSSG from "sssg";
import Dev from "sssg/src/plugins/dev";
import TSCompiler from "sssg/src/plugins/ts-compiler";

import * as path from "path";

const sssg = new SSSG({
  outputFolder: path.join(__dirname, "dist"),
  inputFolder: path.join(__dirname, "website"),
});

await sssg.run({
  plugins: [
    new TSCompiler(),
    new Dev(sssg),
  ],
});

await sssg.build();
```

## design goals:
1. rewrite and generate custom HTML/TS/JS/whatever..
2. allow for variables and other important features in buildsystem->html
3. plugins, this ties together the top two
4. HMR and HTML/CSS reloading (in the Dev plugin)
5. Rewriteable file renaming
6. Every plugin runs on the same set of files, and can rename and reinject multiple times
